/*
 * Decompiled with CFR 0.152.
 */
package com.webhook;

import com.Application;
import com.webhook.repository.CDCRepository;
import java.util.Map;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/Webhook"})
public class Webhook {
    private final CDCRepository repository;
    private final Application application;

    public Webhook(CDCRepository repository, Application application) {
        this.repository = repository;
        this.application = application;
    }

    @PostMapping(value={"/subscribe"})
    public ResponseEntity<Map<String, Object>> subscribe(@RequestBody String body) {
        if (!Application.isAccessWebService || !this.application.usePack2) {
            return null;
        }
        return this.repository.subscribe(body);
    }

    @GetMapping(value={"/start"})
    public ResponseEntity<Map<String, Object>> start() {
        if (!Application.isAccessWebService || !this.application.usePack2) {
            return null;
        }
        return this.repository.startCDC();
    }

    @GetMapping(value={"/stop"})
    public ResponseEntity<Map<String, Object>> stop() {
        if (!Application.isAccessWebService || !this.application.usePack2) {
            return null;
        }
        return this.repository.stopCDC();
    }

    @DeleteMapping(value={"/subscribe"})
    public ResponseEntity<Map<String, Object>> editSub(@RequestParam(value="table", required=false) String param) {
        if (!Application.isAccessWebService || !this.application.usePack2) {
            return null;
        }
        return this.repository.delete(param);
    }

    @GetMapping(value={"/subscribe"})
    public ResponseEntity<?> getSubs() {
        if (!Application.isAccessWebService || !this.application.usePack2) {
            return null;
        }
        return this.repository.getSubs();
    }
}

